/*
 * Decompiled with CFR 0.152.
 */
package exploit.io;

import exploit.conversion.MorphShape;
import exploit.io.ExportSvgHelper;
import exploit.render.AdvancedPath;
import exploit.render.Clipper;
import flash.objects.CXFORMALPHA;
import flash.objects.FBitmap;
import flash.objects.FColor;
import flash.objects.FDisplayListItem;
import flash.objects.FFill;
import flash.objects.FFont;
import flash.objects.FGradient;
import flash.objects.FGradientRecord;
import flash.objects.FLine;
import flash.objects.FLossless;
import flash.objects.FMorph;
import flash.objects.FMovie;
import flash.objects.FMovieData;
import flash.objects.FShape;
import flash.objects.FSolid;
import flash.objects.FText;
import flash.objects.FTextGlyph;
import flash.objects.FTextRecord;
import flash.objects.FTexture;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import mgate.xml.XMLNode;

public class ExportFrameToSVG {
    private int currentGradient;
    private int currentTexture;
    private int currentClip;
    private String image_pre_name;
    private String image_pre_full_name;
    private XMLNode myDefsNode;

    public ExportFrameToSVG(File file, FMovie fMovie, FMovieData fMovieData, boolean bl, boolean bl2) {
        this.image_pre_name = file.getName();
        this.image_pre_name = this.image_pre_name.substring(0, this.image_pre_name.lastIndexOf("."));
        this.image_pre_full_name = file.getPath();
        this.image_pre_full_name = this.image_pre_full_name.substring(0, this.image_pre_full_name.lastIndexOf("."));
        this.currentGradient = 0;
        this.currentClip = 0;
        this.currentTexture = 0;
        XMLNode xMLNode = ExportSvgHelper.createSvgHeader(fMovie);
        this.myDefsNode = new XMLNode("defs");
        xMLNode.addChild(this.myDefsNode);
        XMLNode xMLNode2 = new XMLNode("rect");
        xMLNode2.addProperty("width", (float)(fMovie.getRect().xmax - fMovie.getRect().xmin) / 20.0f + "px");
        xMLNode2.addProperty("height", (float)(fMovie.getRect().ymax - fMovie.getRect().ymin) / 20.0f + "px");
        xMLNode2.addProperty("x", "0px");
        xMLNode2.addProperty("y", "0px");
        xMLNode2.addProperty("fill", "#" + this.convertIntToHex(fMovie.getBackgroundColor().getRed()) + this.convertIntToHex(fMovie.getBackgroundColor().getGreen()) + this.convertIntToHex(fMovie.getBackgroundColor().getBlue()));
        xMLNode.addChild(xMLNode2);
        xMLNode.addChild(this.createLayer(fMovieData.getDisplayList(), null));
        if (bl) {
            XMLNode.dumpCompressedGZip(file, "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n", xMLNode);
        } else {
            XMLNode.dump(file, "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n", xMLNode, bl2);
        }
    }

    public ExportFrameToSVG(File file, FMovie fMovie, Vector vector, boolean bl, boolean bl2) {
        this.image_pre_name = file.getName();
        this.image_pre_name = this.image_pre_name.substring(0, this.image_pre_name.lastIndexOf("."));
        this.image_pre_full_name = file.getPath();
        this.image_pre_full_name = this.image_pre_full_name.substring(0, this.image_pre_full_name.lastIndexOf("."));
        this.currentGradient = 0;
        this.currentClip = 0;
        this.currentTexture = 0;
        XMLNode xMLNode = ExportSvgHelper.createSvgHeader(fMovie);
        xMLNode.sub = this.createShape(null, vector, null);
        if (bl) {
            XMLNode.dumpCompressedGZip(file, "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n", xMLNode);
        } else {
            XMLNode.dump(file, "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n", xMLNode, bl2);
        }
    }

    private XMLNode createLayer(Vector vector, FDisplayListItem fDisplayListItem) {
        XMLNode xMLNode = new XMLNode("g");
        this.addOnDisplayProperties(fDisplayListItem, xMLNode);
        Object var4_4 = null;
        String string = null;
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            XMLNode xMLNode2;
            FDisplayListItem fDisplayListItem2 = (FDisplayListItem)vector.get(i);
            if (fDisplayListItem2 == null) continue;
            String string2 = "";
            if (fDisplayListItem2.getMatrix() != null) {
                string2 = "matrix(";
                string2 = string2 + fDisplayListItem2.getMatrix().getScaleX() + " ";
                string2 = string2 + fDisplayListItem2.getMatrix().getRotateSkew0() + " ";
                string2 = string2 + fDisplayListItem2.getMatrix().getRotateSkew1() + " ";
                string2 = string2 + fDisplayListItem2.getMatrix().getScaleY() + " ";
                string2 = string2 + (float)fDisplayListItem2.getMatrix().getTranslateX() / 20.0f + " ";
                string2 = string2 + (float)fDisplayListItem2.getMatrix().getTranslateY() / 20.0f + ")";
            }
            if (fDisplayListItem2.getClipLayer()) {
                xMLNode2 = new XMLNode("clipPath");
                xMLNode2.addProperty("transform", string2);
                string = "clip" + this.currentClip;
                ++this.currentClip;
                xMLNode2.addProperty("id", string);
                object = null;
                Area area = new Area(Clipper.clip(fDisplayListItem2.getObject()));
                object = new XMLNode("path");
                PathIterator pathIterator = area.getPathIterator(null);
                GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
                generalPath.append(pathIterator, false);
                String string3 = this.parseGeneralPath(generalPath);
                if (string3.length() < 1) continue;
                ((XMLNode)object).addProperty("d", this.parseGeneralPath(generalPath));
                xMLNode2.sub = object;
                xMLNode.addChild(xMLNode2);
                n = fDisplayListItem2.getClipDepth() - 1;
                continue;
            }
            if (n != -1 && n < i) {
                string = null;
                n = -1;
            }
            if (!fDisplayListItem2.isVisible()) continue;
            xMLNode2 = null;
            if (fDisplayListItem2.getObject() instanceof FShape) {
                object = (FShape)fDisplayListItem2.getObject();
                xMLNode2 = this.createShape((FShape)object, null, fDisplayListItem2);
            } else if (fDisplayListItem2.getObject() instanceof FMorph) {
                object = (FMorph)fDisplayListItem2.getObject();
                xMLNode2 = this.createShape(null, MorphShape.getAdvancedPathVector((FMorph)object, (float)fDisplayListItem2.getRatio() / 65535.0f), fDisplayListItem2);
            } else if (fDisplayListItem2.getObject() instanceof FMovieData) {
                object = (FMovieData)fDisplayListItem2.getObject();
                xMLNode2 = this.createLayer(((FMovieData)object).getDisplayList(), fDisplayListItem2);
            } else if (fDisplayListItem2.getObject() instanceof FText) {
                object = (FText)fDisplayListItem2.getObject();
                xMLNode2 = this.createText((FText)object, null, fDisplayListItem2);
                object = null;
            }
            if (xMLNode2 == null) continue;
            if (fDisplayListItem2.getMatrix() != null) {
                xMLNode2.addProperty("transform", string2);
            }
            if (string != null) {
                object = new XMLNode("g");
                ((XMLNode)object).addProperty("clip-path", "url(#" + string + ")");
                ((XMLNode)object).addChild(xMLNode2);
                xMLNode.addChild((XMLNode)object);
                continue;
            }
            xMLNode.addChild(xMLNode2);
        }
        return xMLNode;
    }

    public XMLNode createText(FText fText, Vector vector, FDisplayListItem fDisplayListItem) {
        XMLNode xMLNode = new XMLNode("g");
        boolean bl = false;
        XMLNode xMLNode2 = xMLNode;
        AffineTransform affineTransform = null;
        affineTransform = fText.getMatrix() != null ? fText.getMatrix().getTransform() : new AffineTransform();
        if (fDisplayListItem != null) {
            this.addOnDisplayProperties(fDisplayListItem, xMLNode);
        }
        Vector vector2 = fText.getRecords();
        FFont fFont = null;
        FColor fColor = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            Object e = vector2.get(i);
            if (e instanceof FTextRecord) {
                object = (FTextRecord)e;
                if (((FTextRecord)object).getFont() != null) {
                    fFont = ((FTextRecord)object).getFont();
                    f3 = (float)((FTextRecord)object).getHeight() / 20.0f;
                }
                if (((FTextRecord)object).getColor() != null) {
                    fColor = ((FTextRecord)object).getColor();
                }
                if (!((FTextRecord)object).hasOffsetX() && !((FTextRecord)object).hasOffsetY()) continue;
                f4 = 0.0f;
                if (((FTextRecord)object).hasOffsetX()) {
                    f = (float)((FTextRecord)object).getOffsetX() / 20.0f;
                }
                if (!((FTextRecord)object).hasOffsetY()) continue;
                f2 = (float)((FTextRecord)object).getOffsetY() / 20.0f;
                continue;
            }
            object = (FTextGlyph)e;
            if (fFont == null || fFont.getGlyphs() == null) continue;
            Vector vector3 = fFont.getGlyphs()[((FTextGlyph)object).getIndex()];
            GeneralPath generalPath = null;
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            float f5 = 1.0f;
            f5 = fFont.getFormat() == 3 ? f3 * 100.0f / 1024.0f / 100.0f : f3 * 100.0f / 51.2f / 100.0f;
            affineTransform2.translate(f4 + f, f2);
            affineTransform2.scale(f5, f5);
            f4 += (float)((FTextGlyph)object).getAdvance() / 20.0f;
            for (int j = 0; j < vector3.size(); ++j) {
                Object e2 = vector3.get(j);
                if (!(e2 instanceof AdvancedPath)) continue;
                AdvancedPath advancedPath = (AdvancedPath)vector3.get(j);
                generalPath = advancedPath.getPath();
                XMLNode xMLNode3 = new XMLNode("path");
                String string = "matrix(";
                string = string + affineTransform2.getScaleX() + " ";
                string = string + affineTransform2.getShearX() + " ";
                string = string + affineTransform2.getShearY() + " ";
                string = string + affineTransform2.getScaleY() + " ";
                string = string + affineTransform2.getTranslateX() + " ";
                string = string + affineTransform2.getTranslateY() + ")";
                xMLNode3.addProperty("transform", string);
                xMLNode3.addProperty("d", this.parseGeneralPath(generalPath));
                if (fColor != null) {
                    xMLNode3.addProperty("fill", "#" + this.convertIntToHex(fColor.getR()) + this.convertIntToHex(fColor.getG()) + this.convertIntToHex(fColor.getB()));
                    if (fColor.getA() < 255 && fColor.getA() > 0) {
                        xMLNode3.addProperty("opacity", "" + (float)fColor.getA() / 255.0f);
                    }
                }
                xMLNode.addChild(xMLNode3);
            }
        }
        return xMLNode;
    }

    public XMLNode createShape(FShape fShape, Vector vector, FDisplayListItem fDisplayListItem) {
        XMLNode xMLNode = new XMLNode("g");
        boolean bl = false;
        if (fDisplayListItem != null) {
            this.addOnDisplayProperties(fDisplayListItem, xMLNode);
        }
        XMLNode xMLNode2 = xMLNode;
        if (vector == null) {
            vector = fShape.getRenderData();
        }
        for (int i = 0; i < vector.size(); ++i) {
            bl = false;
            AdvancedPath advancedPath = (AdvancedPath)vector.get(i);
            if (advancedPath.getFill() == null && advancedPath.getLine() == null && (advancedPath.getFill() != null || advancedPath.getLine() != null)) continue;
            GeneralPath generalPath = advancedPath.getPath();
            xMLNode2 = new XMLNode("path");
            FFill fFill = advancedPath.getFill();
            FLine fLine = advancedPath.getLine();
            if (fFill != null) {
                Object object;
                Object object2;
                XMLNode xMLNode3;
                int n;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                FFill fFill2;
                if (fFill.getStyle() == 0) {
                    fFill2 = (FSolid)fFill;
                    object6 = ((FSolid)fFill2).getColor();
                    xMLNode2.addProperty("fill", "#" + this.convertIntToHex(((FColor)object6).getR()) + this.convertIntToHex(((FColor)object6).getG()) + this.convertIntToHex(((FColor)object6).getB()));
                    if (((FColor)object6).getA() < 255 && ((FColor)object6).getA() > 0) {
                        xMLNode2.addProperty("opacity", "" + (float)((FColor)object6).getA() / 255.0f);
                    }
                } else if (fFill.getStyle() == 1) {
                    ++this.currentGradient;
                    fFill2 = (FGradient)fFill;
                    object6 = new XMLNode("linearGradient");
                    ((XMLNode)object6).addProperty("id", "Grad" + this.currentGradient);
                    ((XMLNode)object6).addProperty("gradientUnits", "userSpaceOnUse");
                    object5 = "matrix(";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getScaleX() + " ";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getRotateSkew0() + " ";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getRotateSkew1() + " ";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getScaleY() + " ";
                    object5 = (String)object5 + (float)((FGradient)fFill2).getMatrix().getTranslateX() / 20.0f + " ";
                    object5 = (String)object5 + (float)((FGradient)fFill2).getMatrix().getTranslateY() / 20.0f + ")";
                    ((XMLNode)object6).addProperty("gradientTransform", (String)object5);
                    ((XMLNode)object6).addProperty("x1", "-819.2");
                    ((XMLNode)object6).addProperty("y1", "0");
                    ((XMLNode)object6).addProperty("x2", "819.2");
                    ((XMLNode)object6).addProperty("y2", "0");
                    this.myDefsNode.addChild((XMLNode)object6);
                    object4 = ((FGradient)fFill2).getGradient();
                    object3 = null;
                    for (n = 0; n < ((Vector)object4).size(); ++n) {
                        xMLNode3 = new XMLNode("stop");
                        object2 = (FGradientRecord)((Vector)object4).get(n);
                        object = ((FGradientRecord)object2).getColor();
                        xMLNode3.addProperty("offset", (float)((FGradientRecord)object2).getRatio() / 255.0f + "");
                        xMLNode3.addProperty("stop-color", "#" + this.convertIntToHex(((FColor)object).getR()) + this.convertIntToHex(((FColor)object).getG()) + this.convertIntToHex(((FColor)object).getB()));
                        if (((FColor)object).getA() < 255) {
                            xMLNode3.addProperty("stop-opacity", (float)(((FColor)object).getA() >= 0 ? ((FColor)object).getA() : 0) / 255.0f + "");
                        }
                        if (object3 == null) {
                            ((XMLNode)object6).sub = xMLNode3;
                            object3 = xMLNode3;
                            continue;
                        }
                        ((XMLNode)object3).next = xMLNode3;
                        object3 = xMLNode3;
                    }
                    xMLNode2.addProperty("fill", "url(#Grad" + this.currentGradient + ")");
                } else if (fFill.getStyle() == 2) {
                    ++this.currentGradient;
                    fFill2 = (FGradient)fFill;
                    object6 = new XMLNode("radialGradient");
                    ((XMLNode)object6).addProperty("id", "Grad" + this.currentGradient);
                    ((XMLNode)object6).addProperty("gradientUnits", "userSpaceOnUse");
                    object5 = "matrix(";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getScaleX() + " ";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getRotateSkew0() + " ";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getRotateSkew1() + " ";
                    object5 = (String)object5 + ((FGradient)fFill2).getMatrix().getScaleY() + " ";
                    object5 = (String)object5 + (float)((FGradient)fFill2).getMatrix().getTranslateX() / 20.0f + " ";
                    object5 = (String)object5 + (float)((FGradient)fFill2).getMatrix().getTranslateY() / 20.0f + ")";
                    ((XMLNode)object6).addProperty("gradientTransform", (String)object5);
                    ((XMLNode)object6).addProperty("r", "819.2");
                    ((XMLNode)object6).addProperty("cx", "0");
                    ((XMLNode)object6).addProperty("cy", "0");
                    this.myDefsNode.addChild((XMLNode)object6);
                    object4 = ((FGradient)fFill2).getGradient();
                    object3 = null;
                    for (n = 0; n < ((Vector)object4).size(); ++n) {
                        xMLNode3 = new XMLNode("stop");
                        object2 = (FGradientRecord)((Vector)object4).get(n);
                        object = ((FGradientRecord)object2).getColor();
                        xMLNode3.addProperty("offset", (float)((FGradientRecord)object2).getRatio() / 255.0f + "");
                        xMLNode3.addProperty("stop-color", "#" + this.convertIntToHex(((FColor)object).getR()) + this.convertIntToHex(((FColor)object).getG()) + this.convertIntToHex(((FColor)object).getB()));
                        if (((FColor)object).getA() < 255) {
                            xMLNode3.addProperty("stop-opacity", (float)(((FColor)object).getA() >= 0 ? ((FColor)object).getA() : 0) / 255.0f + "");
                        }
                        if (object3 == null) {
                            ((XMLNode)object6).sub = xMLNode3;
                            object3 = xMLNode3;
                            continue;
                        }
                        ((XMLNode)object3).next = xMLNode3;
                        object3 = xMLNode3;
                    }
                    xMLNode2.addProperty("fill", "url(#Grad" + this.currentGradient + ")");
                } else if (fFill.getStyle() == 3 || fFill.getStyle() == 4) {
                    fFill2 = (FTexture)fFill;
                    object6 = ((FTexture)fFill2).getBitmap();
                    if (object6 == null) continue;
                    object5 = object6.getImage();
                    object4 = null;
                    object3 = null;
                    if (object6 instanceof FBitmap) {
                        object4 = this.image_pre_name + "_" + object6.getID() + ".jpg";
                        object3 = this.image_pre_full_name + "_" + object6.getID() + ".jpg";
                    } else {
                        object4 = this.image_pre_name + "_" + object6.getID() + ".png";
                        object3 = this.image_pre_full_name + "_" + object6.getID() + ".png";
                    }
                    if (object6 instanceof FBitmap && ((FBitmap)object6).getData() != null || object6 instanceof FLossless) {
                        bl = true;
                        String string = "matrix(";
                        string = string + ((FTexture)fFill2).getMatrix().getScaleX() + " ";
                        string = string + ((FTexture)fFill2).getMatrix().getRotateSkew0() + " ";
                        string = string + ((FTexture)fFill2).getMatrix().getRotateSkew1() + " ";
                        string = string + ((FTexture)fFill2).getMatrix().getScaleY() + " ";
                        string = string + (float)((FTexture)fFill2).getMatrix().getTranslateX() / 20.0f + " ";
                        string = string + (float)((FTexture)fFill2).getMatrix().getTranslateY() / 20.0f + ")";
                        xMLNode3 = new XMLNode("clipPath");
                        object2 = "clip" + this.currentClip;
                        ++this.currentClip;
                        xMLNode3.addProperty("id", (String)object2);
                        object = null;
                        object = new XMLNode("path");
                        ((XMLNode)object).addProperty("d", this.parseGeneralPath(generalPath));
                        xMLNode3.sub = object;
                        this.myDefsNode.addChild(xMLNode3);
                        XMLNode xMLNode4 = new XMLNode("image");
                        xMLNode4.addProperty("width", object6.getWidth() + "px");
                        xMLNode4.addProperty("height", object6.getHeight() + "px");
                        xMLNode4.addProperty("xlink:href", (String)object4);
                        xMLNode4.addProperty("transform", string);
                        XMLNode xMLNode5 = new XMLNode("g");
                        xMLNode5.addProperty("clip-path", "url(#" + (String)object2 + ")");
                        xMLNode5.sub = xMLNode4;
                        xMLNode.addChild(xMLNode5);
                        ++this.currentTexture;
                        try {
                            if (object6 instanceof FBitmap) {
                                if (((FBitmap)object6).getData() != null) {
                                    FileOutputStream fileOutputStream = new FileOutputStream(new File((String)object3));
                                    byte[] byArray = ((FBitmap)object6).getData();
                                    for (int j = 0; j < byArray.length; ++j) {
                                        fileOutputStream.write(byArray[j]);
                                    }
                                    fileOutputStream.close();
                                }
                            } else {
                                ImageIO.write((RenderedImage)object6.getImage(), "PNG", new File((String)object3));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        xMLNode2.addProperty("fill", "none");
                    } else {
                        xMLNode2.addProperty("fill", "#111111");
                    }
                } else {
                    xMLNode2.addProperty("fill", "#111111");
                }
            } else if (fLine != null) {
                xMLNode2.addProperty("fill", "none");
                xMLNode2.addProperty("stroke", "#" + this.convertIntToHex(fLine.getColor().getR()) + this.convertIntToHex(fLine.getColor().getG()) + this.convertIntToHex(fLine.getColor().getB()));
                xMLNode2.addProperty("stroke-width", "" + (float)fLine.getWidth() / 20.0f);
            }
            xMLNode2.addProperty("stroke-linecap", "round");
            xMLNode2.addProperty("stroke-linejoin", "round");
            xMLNode2.addProperty("d", this.parseGeneralPath(generalPath));
            if (bl) continue;
            xMLNode.addChild(xMLNode2);
        }
        return xMLNode;
    }

    private boolean doesItemExist(XMLNode xMLNode, String string, String string2, String string3) {
        xMLNode = xMLNode.sub;
        String string4 = null;
        while (xMLNode != null) {
            if (xMLNode.getTitle().equals(string) && (string4 = xMLNode.getProperty(string2)) != null && string4.equals(string3)) {
                return true;
            }
            xMLNode = xMLNode.next;
        }
        return false;
    }

    private void addOnDisplayProperties(FDisplayListItem fDisplayListItem, XMLNode xMLNode) {
        CXFORMALPHA cXFORMALPHA;
        if (fDisplayListItem != null && (cXFORMALPHA = fDisplayListItem.getCXFORMALPHA()) != null) {
            if (cXFORMALPHA.HasAddTerms()) {
                if (cXFORMALPHA.getAdd(3) > 0 && cXFORMALPHA.getAdd(3) <= 255) {
                    xMLNode.addProperty("opacity", "" + (float)cXFORMALPHA.getAdd(3) / 255.0f);
                }
            } else if (cXFORMALPHA.HasMultTerms() && cXFORMALPHA.getMulti(3) > 0 && cXFORMALPHA.getMulti(3) <= 255) {
                xMLNode.addProperty("opacity", "" + (float)cXFORMALPHA.getMulti(3) / 255.0f);
            }
        }
    }

    private String parseGeneralPath(GeneralPath generalPath) {
        PathIterator pathIterator = null;
        pathIterator = generalPath.getPathIterator(null);
        float[] fArray = new float[6];
        String string = "";
        float f = 0.0f;
        float f2 = 0.0f;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 4: {
                    string = this.addPartToSvgString(string, "Z");
                    break;
                }
                case 3: {
                    string = this.addPartToSvgString(string, "C");
                    string = this.addPartToSvgString(string, "" + fArray[0]);
                    string = this.addPartToSvgString(string, "" + fArray[1]);
                    string = this.addPartToSvgString(string, "" + fArray[2]);
                    string = this.addPartToSvgString(string, "" + fArray[3]);
                    string = this.addPartToSvgString(string, "" + fArray[4]);
                    string = this.addPartToSvgString(string, "" + fArray[5]);
                    f = fArray[4];
                    f2 = fArray[5];
                    break;
                }
                case 2: {
                    float f3 = f + 0.6666667f * (fArray[0] - f);
                    float f4 = f2 + 0.6666667f * (fArray[1] - f2);
                    float f5 = f3 + 0.33333334f * (fArray[2] - f);
                    float f6 = f4 + 0.33333334f * (fArray[3] - f2);
                    string = this.addPartToSvgString(string, "C");
                    string = this.addPartToSvgString(string, "" + f3);
                    string = this.addPartToSvgString(string, "" + f4);
                    string = this.addPartToSvgString(string, "" + f5);
                    string = this.addPartToSvgString(string, "" + f6);
                    string = this.addPartToSvgString(string, "" + fArray[2]);
                    string = this.addPartToSvgString(string, "" + fArray[3]);
                    f = fArray[2];
                    f2 = fArray[3];
                    break;
                }
                case 1: {
                    string = this.addPartToSvgString(string, "L");
                    string = this.addPartToSvgString(string, "" + fArray[0]);
                    string = this.addPartToSvgString(string, "" + fArray[1]);
                    f = fArray[0];
                    f2 = fArray[1];
                    break;
                }
                case 0: {
                    string = this.addPartToSvgString(string, "M");
                    string = this.addPartToSvgString(string, "" + fArray[0]);
                    string = this.addPartToSvgString(string, "" + fArray[1]);
                    f = fArray[0];
                    f2 = fArray[1];
                }
            }
            pathIterator.next();
        }
        return string;
    }

    private String addPartToSvgString(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        char c = string.charAt(string.length() - 1);
        char c2 = string2.charAt(0);
        if (c2 > '0' || c2 < '9') {
            if (c > '0' || c < '9') {
                return string + " " + string2;
            }
            return string + string2;
        }
        return string + string2;
    }

    private String convertIntToHex(int n) {
        int n2 = n / 16;
        int n3 = n % 16;
        return ExportFrameToSVG.getHexChar(n2) + ExportFrameToSVG.getHexChar(n3);
    }

    public static String getHexChar(int n) {
        if (n < 10) {
            return "" + n + "";
        }
        switch (n) {
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return "?";
    }
}

